from fastapi import Response
from twilio.rest import Client
import asyncio

class TwilioManager:
    def __init__(self, app_integration, app_details):
        self.app_integration = app_integration
        self.app_details = app_details
        self.account_sid = app_integration['auth_config']['credentials']['account_sid']
        self.auth_token = app_integration['auth_config']['credentials']['auth_token']
        self.from_number = app_integration['configurations']['From_Number']
        self.contact_number = app_integration['configurations']['Contact_Number']
        self.sms_message = app_integration['configurations']['SMS_Message']
        self.voice_url = app_integration.get('configurations', {}).get('Voice_MP3_URL', '')
        self.client = Client(self.account_sid,self.auth_token)

    async def get_number(self, request):
        if isinstance(request, dict):
            mobile = request.get("mobile")
        else:
            mobile = request.query_params.get("mobile")

        if mobile:
            mobile = mobile.strip()  # Removes leading/trailing spaces
        return mobile

    async def phone_call(self, request):
        mobile = await self.get_number(request)

        # Create a TwiML response
        twiml_response = "<Response><Say voice='woman'>Thanks for reaching out!</Say><Play>" + self.voice_url + "</Play></Response>"

        # Initiate the phone call
        call = self.client.calls.create(
            twiml=twiml_response,
            to=mobile,
            from_=self.from_number
        )
        return {"status": "success", "message": "Introduction call initiated to " + mobile}


    async def conference_call(self, request):
        phone = await self.get_number(request)
        conference_name = "MyConferenceRoom"
        twiml_response = f'<Response><Dial><Conference>{conference_name}</Conference></Dial></Response>'


        call1 = self.client.calls.create(
            twiml=twiml_response,
            to=self.contact_number,
            from_=self.from_number
        )

        await asyncio.sleep(5)

        call2 = self.client.calls.create(
            twiml=twiml_response,
            to=phone,
            from_=self.from_number
        )

        name = request.get("name", "Unknown")

        # Construct the message body including the Name and phone
        message_body = f"You have got a new request for a conference call. Name: {name}, Phone: {phone}"

        message = self.client.messages.create(
            body=message_body,
            from_=self.from_number,
            to=self.contact_number
        )

        return {
            "status": "success",
            "message": f"Conference initiated with calls {self.contact_number} and {phone}"
        }

    async def send_sms(self, request):
        phone = await self.get_number(request)

        message = self.client.messages.create(
            body=self.sms_message,
            from_=self.from_number,
            to=phone
        )
        return {"status": "success", "message": "SMS sent to " + phone}


    async def send_email(self, request):
        email = request.data.get("email")  # Assuming email is provided in the request data
        email_subject = request.data.get("subject")  # Assuming subject is provided in the request data
        email_body = request.data.get("body")  # Assuming body is provided in the request data
        if not email or not email_subject or not email_body:
            return {"status": "error", "message": "Email, subject, or body missing"}

        return {"status": "success", "message": f"Email sent to {email}"}

    async def addto_contacts(self, request):
        email = request.data.get("email")  # Assuming email is provided in the request data
        return {"status": "success", "message": f"Added {email} to contacts"}

#+19135433373
#ACb902bdc4aa28f74592bb02e681cb4f60
#e874a3731c82c6bbdc9436244c2c2427